/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;

public record DepthTempData(List<TempRegion> temperatures, List<Either<TagKey<DimensionType>, DimensionType>> dimensions, Optional<List<String>> requiredMods) {
    public static final Codec<DepthTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TempRegion.CODEC.listOf().fieldOf("regions").forGetter(DepthTempData::temperatures), (App)ConfigHelper.tagOrVanillaRegistryCodec(Registry.f_122818_, DimensionType.f_63853_).listOf().fieldOf("dimensions").forGetter(DepthTempData::dimensions), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(DepthTempData::requiredMods)).apply((Applicative)instance, DepthTempData::new));

    public boolean withinBounds(Level level, BlockPos pos) {
        Holder dim = level.m_204156_();
        if (!CSMath.anyMatch(this.dimensions, dimension -> (Boolean)dimension.map(arg_0 -> ((Holder)dim).m_203656_(arg_0), type -> type.equals(dim.m_203334_())))) {
            return false;
        }
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Double getTemperature(double temperature, BlockPos pos, Level level) {
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region.getTemperature(temperature, pos, level);
        }
        return null;
    }

    public record TempRegion(RampType rampType, VerticalBound top, VerticalBound bottom) {
        public static final TempRegion NONE = new TempRegion(RampType.CONSTANT, VerticalBound.NONE, VerticalBound.NONE);
        public static final Codec<TempRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RampType.CODEC.optionalFieldOf("type", (Object)RampType.CONSTANT).forGetter(TempRegion::rampType), (App)VerticalBound.CODEC.optionalFieldOf("top", (Object)VerticalBound.NONE).forGetter(TempRegion::top), (App)VerticalBound.CODEC.optionalFieldOf("bottom", (Object)VerticalBound.NONE).forGetter(TempRegion::bottom)).apply((Applicative)instance, (type, top, bottom) -> {
            if (top == VerticalBound.NONE && bottom == VerticalBound.NONE) {
                throw new IllegalArgumentException("Temperature region must have at least one bound");
            }
            if (top == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw new IllegalArgumentException("\"top\" region undefined. Boundless temperature region must have a constant temperature");
                }
                top = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MAX_VALUE, bottom.units, bottom.temperature);
            }
            if (bottom == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw new IllegalArgumentException("\"bottom\" region undefined. Boundless temperature region must have a constant temperature");
                }
                bottom = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MIN_VALUE, top.units, top.temperature);
            }
            if (type == RampType.CONSTANT && !top.temperature.equals(bottom.temperature)) {
                throw new IllegalArgumentException("Constant temperature ramp type must have a constant temperature; got " + top.temperature + " and " + bottom.temperature);
            }
            return new TempRegion((RampType)((Object)((Object)type)), (VerticalBound)top, (VerticalBound)bottom);
        }));

        public boolean withinBounds(Level level, BlockPos pos) {
            return pos.m_123342_() <= this.top.getHeight(pos, level) && pos.m_123342_() >= this.bottom.getHeight(pos, level);
        }

        public double getTemperature(double temperature, BlockPos pos, Level level) {
            double topTemp = Temperature.convert(this.top.getTemperature(temperature), this.top.units, Temperature.Units.MC, true);
            double bottomTemp = Temperature.convert(this.bottom.getTemperature(temperature), this.bottom.units, Temperature.Units.MC, true);
            return switch (this.rampType) {
                default -> throw new IncompatibleClassChangeError();
                case RampType.CONSTANT -> {
                    if (pos.m_123342_() <= this.bottom.getHeight(pos, level)) {
                        yield bottomTemp;
                    }
                    yield topTemp;
                }
                case RampType.LINEAR -> CSMath.blend(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                case RampType.EXPONENTIAL -> CSMath.blendExp(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                case RampType.LOGARITHMIC -> CSMath.blendLog(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
            };
        }
    }

    public static enum VerticalAnchor implements StringRepresentable
    {
        CONSTANT("constant"),
        WORLD_TOP("world_top"),
        WORLD_BOTTOM("world_bottom"),
        GROUND_LEVEL("ground_level");

        private final String name;
        public static final Codec<VerticalAnchor> CODEC;

        private VerticalAnchor(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static VerticalAnchor byName(String name) {
            for (VerticalAnchor type : VerticalAnchor.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown vertical anchor: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(VerticalAnchor::byName, VerticalAnchor::m_7912_);
        }
    }

    public static enum RampType implements StringRepresentable
    {
        CONSTANT("constant"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        private final String name;
        public static final Codec<RampType> CODEC;

        private RampType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static RampType byName(String name) {
            for (RampType type : RampType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown ramp type: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(RampType::byName, RampType::m_7912_);
        }
    }

    public record VerticalBound(VerticalAnchor anchor, Integer depth, Temperature.Units units, TempContainer temperature) {
        public static final VerticalBound NONE = new VerticalBound(VerticalAnchor.CONSTANT, 0, Temperature.Units.MC, TempContainer.NONE);
        public static final Codec<VerticalBound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.optionalFieldOf("anchor", (Object)VerticalAnchor.CONSTANT).forGetter(VerticalBound::anchor), (App)Codec.INT.fieldOf("depth").forGetter(VerticalBound::depth), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(VerticalBound::units), (App)TempContainer.CODEC.fieldOf("temperature").forGetter(VerticalBound::temperature)).apply((Applicative)instance, VerticalBound::new));

        public int getHeight(BlockPos checkPos, Level level) {
            return switch (this.anchor) {
                default -> throw new IncompatibleClassChangeError();
                case VerticalAnchor.CONSTANT -> this.depth;
                case VerticalAnchor.WORLD_TOP -> level.m_151558_() + this.depth;
                case VerticalAnchor.WORLD_BOTTOM -> level.m_141937_() + this.depth;
                case VerticalAnchor.GROUND_LEVEL -> WorldHelper.getHeight(checkPos, level) + this.depth;
            };
        }

        public double getTemperature(double temperature) {
            return switch (this.temperature.type) {
                default -> throw new IncompatibleClassChangeError();
                case ContainerType.STATIC -> {
                    if (this.temperature.strength == 0.0) {
                        yield temperature;
                    }
                    yield CSMath.blend(temperature, this.temperature.temperature, this.temperature.strength, 0.0, 1.0);
                }
                case ContainerType.MIDPOINT -> this.temperature.strength == 0.0 ? temperature : CSMath.blend(temperature, (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0, this.temperature.strength, 0.0, 1.0);
            };
        }

        public record TempContainer(double temperature, ContainerType type, double strength) {
            public static final TempContainer NONE = new TempContainer(0.0, ContainerType.STATIC, 1.0);
            public static final Codec<TempContainer> CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("value", (Object)Double.NaN).forGetter(TempContainer::temperature), (App)ContainerType.CODEC.optionalFieldOf("type", (Object)ContainerType.STATIC).forGetter(TempContainer::type), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("strength", (Object)1.0).forGetter(TempContainer::strength)).apply((Applicative)instance, (temp, type, strength) -> {
                if (type == ContainerType.STATIC && temp.equals(Double.NaN) && strength > 0.0) {
                    throw new IllegalArgumentException("Static temperature container must have a temperature");
                }
                return new TempContainer((double)temp, (ContainerType)((Object)((Object)type)), (double)strength);
            })), (Codec)Codec.DOUBLE.xmap(d -> new TempContainer((double)d, ContainerType.STATIC, 1.0), TempContainer::temperature)).xmap(either -> (TempContainer)either.map(c -> c, c -> c), container -> container.type == ContainerType.STATIC ? Either.right((Object)container) : Either.left((Object)container));

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof TempContainer)) return false;
                TempContainer container = (TempContainer)obj;
                if (!Double.valueOf(container.temperature).equals(this.temperature)) return false;
                if (container.type != this.type) return false;
                if (container.strength != this.strength) return false;
                return true;
            }
        }

        public static enum ContainerType implements StringRepresentable
        {
            STATIC("static"),
            MIDPOINT("midpoint");

            private final String name;
            public static final Codec<ContainerType> CODEC;

            private ContainerType(String name) {
                this.name = name;
            }

            public String m_7912_() {
                return this.name;
            }

            public static ContainerType byName(String name) {
                for (ContainerType type : ContainerType.values()) {
                    if (!type.name.equals(name)) continue;
                    return type;
                }
                throw new IllegalArgumentException("Unknown special temperature value: " + name);
            }

            static {
                CODEC = Codec.STRING.xmap(ContainerType::byName, ContainerType::m_7912_);
            }
        }
    }
}

